/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction.repair.effectors;

import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.managedsystem.VerifyException;
import com.ibm.hwmca.fw.service.panel.CommonDataBean;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.panel.PBCommonVerifySuccessful;
import com.ibm.hwmca.xfw.service.serviceaction.repair.effectors.VerifyUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ApplicationLevelVerify
implements Effector {
    private static final String TRACE_MASKT = "XRVXALVT";
    private static final String TRACE_MASKF = "XRVXALVF";
    private static final String TRACE_MASKD = "XRVXALVD";
    protected LocalizableText verifyDoneHeading = new LocalizableText("Verification progress");
    protected LocalizableText verifyDoneBody = new LocalizableText("Verification completed with no errors detected.");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(Context context) throws EffectorException {
        Trace.trace(TRACE_MASKT, "-> ApplicationLevelVerify.fire");
        try {
            Map userData = context.getUserData();
            List fruList = (List)userData.get("SELECTED_FRUS");
            Iterator it = fruList.iterator();
            try {
                while (it.hasNext()) {
                    ServiceableElement se = (ServiceableElement)it.next();
                    se.applicationLevelVerify(userData);
                }
                VerifyUtils.defaultVerify(userData);
                GenericGui displayHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
                PBCommonVerifySuccessful bean = new PBCommonVerifySuccessful();
                try {
                    displayHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", ((CommonDataBean)bean).getTemplateName(), bean, userData);
                }
                catch (Exception toss) {
                }
                finally {
                    try {
                        displayHandle.destroyBusyDialog(userData);
                    }
                    catch (Exception toss) {}
                }
            }
            catch (VerifyException e) {
                context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(VerifyUtils.evaluateException(userData, e));
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! ApplicationLevelVerify.fire exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            if (!(e instanceof EffectorException)) {
                throw new EffectorException(e);
            }
            throw (EffectorException)e;
        }
        Trace.trace(TRACE_MASKT, "<- ApplicationLevelVerify.fire");
    }
}

